/**
  ******************************************************************************
  * @file stm8l10x_it.h
  * @brief This file contains the external declarations of the interrupt routines.
  * @author STMicroelectronics - MCD Application Team
  * @version V1.0.0
  * @date 04/10/2009
  ******************************************************************************
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2009 STMicroelectronics</center></h2>
  * @image html logo.bmp
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __STM8L10x_IT_H
#define __STM8L10x_IT_H

/* Includes ------------------------------------------------------------------*/
#include "stm8l10x.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
#ifdef _COSMIC_
void NonHandledInterrupt(void);
void _stext(void); /* RESET startup routine */
#endif /* _COSMIC_ */
void TRAP_IRQHandler(void); /* TRAP */
void FLASH_IRQHandler(void); /* FLASH EOP/PG_DIS */
void AWU_IRQHandler(void); /* AWU */
void EXTIB_IRQHandler(void); /* EXTI PORTB */
void EXTID_IRQHandler(void); /* EXTI PORTD */
void EXTI0_IRQHandler(void); /* EXTI PIN0 */
void EXTI1_IRQHandler(void); /* EXTI PIN1 */
void EXTI2_IRQHandler(void); /* EXTI PIN2 */
void EXTI3_IRQHandler(void); /* EXTI PIN3 */
void EXTI4_IRQHandler(void); /* EXTI PIN4 */
void EXTI5_IRQHandler(void); /* EXTI PIN5 */
void EXTI6_IRQHandler(void); /* EXTI PIN6 */
void EXTI7_IRQHandler(void); /* EXTI PIN7 */
void COMP_IRQHandler(void); /* COMP */
void TIM2_UPD_OVF_TRG_BRK_IRQHandler(void); /* TIM2 UPD/OVF/TRG/BRK */
void TIM2_CAP_IRQHandler(void); /* TIM2 CAP*/
void TIM3_UPD_OVF_TRG_BRK_IRQHandler(void); /* TIM3 UPD/OVF/TRG/BRK */
void TIM3_CAP_IRQHandler(void); /* TIM3 CAP*/
void TIM4_UPD_OVF_IRQHandler(void); /* TIM4 UPD/OVF */
void SPI_IRQHandler(void); /* SPI */
void USART_TX_IRQHandler(void); /* USART TX */
void USART_RX_IRQHandler(void); /* USART RX */
void I2C_IRQHandler(void); /* I2C */

#endif /* __STM8L10x_IT_H */

/******************* (C) COPYRIGHT 2009 STMicroelectronics *****END OF FILE****/

